Scriptname SuH_spellES_pet extends activemagiceffect

;	Pet reference style script applied via ability script which tracks any events that must run on a per-pet basis or needs to run directly on thier reference such as onHit. When pets are unsummoned this script doesn't run it's onUpdate function since the pet, and this script, will be set to disabled, however the script will resume when the pet is re-summoned and they are set to enabled again.

SuH_Fun property _f auto
SuH_Status property _s auto

int hitcd = 0
int lust4pcbuildup = 0
int lust4npcbuildup = 0
bool OnHitProcessing = false
actor char

Event OnInit()
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	
endEvent

Event OnEffectStart(Actor akTarget, Actor akCaster)
	char = akTarget
	RegisterForSingleUpdate(5.0) ; tick in 5 seconds
endEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	if OnHitProcessing == false ; if not already processing
		OnHitProcessing = true ; mark as processing
		if hitcd < 1
			bool hostileProcess = false
			if akSource as Spell ; If hit is from a spell
				if (akSource as Spell).IsHostile() ; Check if spell is hostile
					hostileProcess = true ; set hostile
				else
					hostileProcess = false ; set non-hostile
				endIf
			else ; if not a spell hit, make hostile
				hostileProcess = true
			endIf
			if hostileProcess
				int x = _f.PetFindSlot(char) ; get pet slot
				if _s.SuH_pettrait0[x] == 12 || _s.SuH_pettrait1[x] == 12 || _s.SuH_pettrait2[x] == 12 ; If has masochist trait
					_f.Pet_addXP(char, 22)
				else
					_f.Pet_addXP(char, 14)
				endIf
				hitcd += 5 ; increase hit cooldown by 5 seconds
				if akAggressor == _s.PlayerRef
					_f.PCE_stattrack("Pethit")
				endIf
			endIf
		endIf
		OnHitProcessing = false ; mark as no longer processing
	endIf
endEvent

Event OnDying(Actor attchar)
	_f.PetDeath(char)
endEvent

Event OnUpdate()
if (!Utility.IsInMenuMode() && char.Is3DLoaded())
	if hitcd > 0
		hitcd -= 5 ; reduce hit cooldown by tick rate (5 seconds)
	endIf
	if _s.SuH_Frame_SexLab > 0 && char.GetWorldspace() == _s.PlayerRef.GetWorldSpace() ; if in same worldspace as player
		int petslot = _f.PetFindSlot(char) ; get pet slot
		int x = _s.SexLab.ValidateActor(char)
		if x == -10 ; if in animation
			_f.Pet_addXP(char, 2)
		elseif x > 0 ; if not in anim but still valid
			;	If player aroused or pet has Master Cravings trait
			if _s.SuH_SETarousaldefect > 0 && _s.SuH_PCSarousalstate >= 3 || _s.SuH_pettrait0[petslot] == 9 || _s.SuH_pettrait1[petslot] == 9 || _s.SuH_pettrait2[petslot] == 9
				lust4pcbuildup += Utility.RandomInt(0,500) ; Random build-up for player
				if lust4pcbuildup >= 12000 ; min-time of 2 minutes
					if _s.Sexlab.ValidateActor(_s.playerRef) > 0 ; if player is valid
						debug.Notification("Soul Pet is Lusting...")
						actor[] animActor = new actor[2]
						animActor[0] = _s.PlayerRef
						animActor[1] = char
						if _f.Scene_StartThread(animActor, _s.PlayerRef) < 0 ; start aggressive animation
							lust4pcbuildup -= 100 ; if anim failed, reduce buildup to try again
						else
							lust4pcbuildup = 0 ; if anim started, reset lust values
							lust4npcbuildup = 0
						endIf
					endIf
				endIf
			endIf
			;	If pet has Lustful trait
			if _s.SuH_pettrait0[petslot] == 10 || _s.SuH_pettrait1[petslot] == 10 || _s.SuH_pettrait2[petslot] == 10
				int y = Utility.RandomInt(0,500) ; Random lust build-up
				lust4npcbuildup +=  y
				lust4pcbuildup += (y / 2)
				if lust4npcbuildup >= 12000 ; min-time of 2 minutes
					; set gender find variable - needs function to check for gender availability
					int preferGender = -1 ; default to male or female
					int petgender = _s.SexLab.GetGender(char)
					if petgender == 2 && _s.SuH_SETallowmalehomo == 0 || petgender == 0 && _s.SuH_SETallowmalehomo == 0; if male and homo disabled
						preferGender = 1 ; search for female only
					elseif petgender == 3 && _s.SuH_SETallowfemalehomo == 0 || petgender == 1 && _s.SuH_SETallowfemalehomo == 0; if female and homo disabled
						preferGender = 0 ; search for male only
					endIf
					
					actor foundactor = _s.SexLab.FindAvailableActor(char, 2000.0, preferGender, _s.PlayerRef) ; center search on pet, 2000 radius, search for gender x, ignore player ;Actor IgnoreRef2 = none, Actor IgnoreRef3 = none, Actor IgnoreRef4 = none)
					
					if _s.Sexlab.ValidateActor(foundactor) > 0 ; if found actor is valid
						debug.Notification("Soul Pet is Lusting...")
						actor[] animActor = new actor[2]
						animActor[0] = foundactor
						animActor[1] = char
						if _f.Scene_StartThread(animActor, foundactor) < 0 ; start aggressive animation
							lust4npcbuildup -= 200 ; if anim failed, reduce buildup to try again
						else
							lust4pcbuildup = 0 ; if anim started, reset lust values
							lust4npcbuildup = 0
						endIf
					endIf
				endIf
				;	If NPC act failed, try for player
				if lust4pcbuildup >= 12000 ; min-time of 2 minutes
					if _s.Sexlab.ValidateActor(_s.playerRef) > 0 ; if player is valid
						debug.Notification("Soul Pet is Lusting...")
						actor[] animActor = new actor[2]
						animActor[0] = _s.PlayerRef
						animActor[1] = char
						if _f.Scene_StartThread(animActor, _s.PlayerRef) < 0 ; start aggressive animation
							lust4pcbuildup -= 100 ; if anim failed, reduce buildup to try again
						else
							lust4pcbuildup = 0 ; if anim started, reset lust values
							lust4npcbuildup = 0
						endIf
					endIf
				endIf
			endIf
		endIf
	endIf
	RegisterForSingleUpdate(5.0) ; tick in 5 seconds
endIf
endEvent
